/*
 * Decompiled with CFR 0.152.
 */
package jace.hardware;

import jace.config.Name;
import jace.core.RAMEvent;
import jace.hardware.CardSSC;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

@Name(value="Hayes Micromodem II")
public class CardHayesMicromodem
extends CardSSC {
    public int RING_INDICATOR_REG = 5;
    private boolean ringIndicator = false;

    @Override
    public String getDeviceName() {
        return "Hayes Micromodem";
    }

    public CardHayesMicromodem() {
        this.ACIA_Data = 7;
        this.ACIA_Status = 6;
        this.ACIA_Control = 5;
        this.ACIA_Command = 6;
        this.SW1 = 255;
        this.SW1_SETTING = 255;
        this.SW2_CTS = 255;
        this.RECV_IRQ_ENABLED = false;
        this.TRANS_IRQ_ENABLED = false;
    }

    @Override
    public void clientConnected() {
        this.setRingIndicator(true);
        super.clientConnected();
    }

    @Override
    public void clientDisconnected() {
        this.setRingIndicator(false);
        super.clientDisconnected();
    }

    @Override
    protected void handleIOAccess(int register, RAMEvent.TYPE type, int value, RAMEvent e) {
        if (register == this.ACIA_Data) {
            super.handleIOAccess(register, type, value, e);
            return;
        }
        if (type.isRead() && register == this.RING_INDICATOR_REG) {
            e.setNewValue(this.isRingIndicator() ? 0 : 255);
        } else if (type.isRead() && register == this.ACIA_Status) {
            e.setNewValue(this.getStatusValue());
        } else if (type == RAMEvent.TYPE.WRITE && register == this.ACIA_Control) {
            if ((value & 0x80) == 0) {
                System.out.println("Software triggered disconnect");
                try {
                    if (this.clientSocket != null) {
                        this.clientSocket.getOutputStream().write("Disconnected by host\n".getBytes());
                    }
                }
                catch (IOException ex) {
                    System.out.println("Client disconnected before host");
                }
                this.hangUp();
                this.setRingIndicator(false);
            } else {
                System.out.println("Software answered connect request");
                try {
                    if (this.clientSocket != null) {
                        this.clientSocket.getOutputStream().write("Connected to emulated Apple\n".getBytes());
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(CardHayesMicromodem.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.setRingIndicator(false);
            }
        }
    }

    @Override
    public void loadRom(String path) throws IOException {
    }

    public boolean isRingIndicator() {
        return this.ringIndicator;
    }

    public void setRingIndicator(boolean ringIndicator) {
        this.ringIndicator = ringIndicator;
    }

    private int getStatusValue() {
        int status = 0;
        try {
            if (this.inputAvailable()) {
                status |= 1;
            }
            status |= 2;
            if (this.isRingIndicator() || !this.isConnected()) {
                status |= 4;
            }
        }
        catch (Throwable ex) {
            Logger.getLogger(CardHayesMicromodem.class.getName()).log(Level.SEVERE, null, ex);
        }
        return status;
    }
}

